/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.heal;

import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.item.heal.AbstractHealItem;
import dev.toma.gunsrpg.util.SkillUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;

public class PlayerHealItem
extends AbstractHealItem<PlayerEntity> {
    protected PlayerHealItem(Builder builder) {
        super(builder);
    }

    public static AbstractHealItem.HealBuilder<PlayerEntity, PlayerHealItem> define(String name) {
        return new Builder(name);
    }

    @Override
    protected boolean shouldApplyHealBonus() {
        return false;
    }

    public static void onSteroidsUsed(PlayerEntity player) {
        float value = PlayerData.getUnsafe(player).getAttributes().getAttribute(Attribs.STEROIDS_EFFECT).floatValue();
        int length = (int)(1200.0f * value);
        player.func_195064_c(new EffectInstance(Effects.field_76420_g, length, 0, false, false));
        player.func_195064_c(new EffectInstance(Effects.field_76430_j, length, 1, false, false));
    }

    public static void onAdrenalineUsed(PlayerEntity player) {
        float value = PlayerData.getUnsafe(player).getAttributes().getAttribute(Attribs.ADRENALINE_EFFECT).floatValue();
        player.func_195064_c(new EffectInstance(Effects.field_76428_l, (int)(700.0f * value), 0, false, false));
        player.func_195064_c(new EffectInstance(Effects.field_76424_c, (int)(1200.0f * value), 0, false, false));
    }

    public static void onMorphineUsed(PlayerEntity player) {
        SkillUtil.heal(player, 14.0f);
        float value = PlayerData.getUnsafe(player).getAttributes().getAttribute(Attribs.MORPHINE_EFFECT).floatValue();
        player.func_195064_c(new EffectInstance(Effects.field_76428_l, (int)(300.0f * value), 1, false, false));
        player.func_195064_c(new EffectInstance(Effects.field_76420_g, (int)(900.0f * value), 1, false, false));
        player.func_195064_c(new EffectInstance(Effects.field_76429_m, (int)(1200.0f * value), 0, false, false));
    }

    @Override
    public PlayerEntity getTargetObject(World world, PlayerEntity user, IPlayerData data) {
        return user;
    }

    protected static class Builder
    extends AbstractHealItem.HealBuilder<PlayerEntity, PlayerHealItem> {
        protected Builder(String name) {
            super(name);
        }

        @Override
        public PlayerHealItem build() {
            return new PlayerHealItem(this);
        }
    }
}

